<?php

class XChiefAPI
{
    private $baseUrl = 'https://api.xchief.com';
    private $token;

    public function __construct($token)
    {
        $this->token = $token;
    }

    // Get list of all referred clients
    public function getClients()
    {
        return $this->sendGetRequest('/v1/partners/clients');
    }

    // Get specific client by email
    public function getClient($email)
    {
        return $this->sendGetRequest('/v1/partners/client', [
            'email' => $email,
        ]);
    }

    // Get client turnover between two dates
    public function getClientTurnover($email, $startDate, $endDate)
    {
        return $this->sendGetRequest('/v1/partners/client/turnover', [
            'email'      => $email,
            'start_date' => $startDate,
            'end_date'   => $endDate,
        ]);
    }

    // Private method to handle GET requests
    private function sendGetRequest($endpoint, $params = [])
    {
        $queryString = !empty($params) ? '?' . http_build_query($params) : '';
        $url = $this->baseUrl . $endpoint . $queryString;

        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Authorization: ' . $this->token,
        ]);

        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            return ['error' => curl_error($ch)];
        }

        curl_close($ch);

        return json_decode($response, true);
    }
}


// =======================
// مثال استفاده
// =======================

$token = "cF5yNDhigvm2-FY54beB-2OdSdjjxSgaQ5vRp6sEqGWleqdI-cntmpbAvMbRe1yFIs2rz_p5HrCMZP8q4ZUsYJA9QtMuBQ8flYgwamYB0WyFwq7161_JsoG1XkBPK8fJkJ-wBkGaxPnkPGmcEjHlYw";
$brokerApi = new XChiefAPI($token);

// لیست همه مشتریان
$clients = $brokerApi->getClients();
print_r($clients);

// اطلاعات یک مشتری خاص
// $client = $brokerApi->getClient('dr.babazadeh@yahoo.com');
// print_r($client);

// // گردش مالی یک مشتری
// $turnover = $brokerApi->getClientTurnover('meqdad.dehqani72@gmail.com', '2025-01-01', '2025-12-01');
// print_r($turnover);

